/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.scarves;

import blue.endless.scarves.ScarvesMod;
import blue.endless.scarves.api.FabricSquare;
import blue.endless.scarves.api.FabricSquareRegistry;
import blue.endless.scarves.ghost.GhostInventory;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1263;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class WScarfPreview
extends WWidget {
    protected int panelSize = 24;
    protected int maxSquares = 8;
    private GhostInventory inventory = null;
    private class_1263 exemplarInventory = null;
    private int exemplarSlot = 0;
    private Axis axis = Axis.HORIZONTAL;

    public WScarfPreview(GhostInventory inventory, Axis axis) {
        this.inventory = inventory;
        this.axis = axis;
    }

    public WScarfPreview(class_1263 inventory, int slot, Axis axis) {
        this.exemplarInventory = inventory;
        this.exemplarSlot = slot;
        this.axis = axis;
    }

    public void setPanelSize(int value) {
        this.panelSize = value;
    }

    public void setMaxSquares(int value) {
        this.maxSquares = value;
    }

    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        block4: {
            int iy;
            int ix;
            int dy;
            int dx;
            block3: {
                dx = this.axis == Axis.HORIZONTAL ? this.panelSize : 0;
                dy = this.axis == Axis.HORIZONTAL ? 0 : this.panelSize;
                ix = this.x + x;
                iy = this.y + y;
                if (this.inventory == null) break block3;
                int squares = Math.min(this.maxSquares, this.inventory.getGhostInventorySize());
                for (int i = 0; i < squares; ++i) {
                    FabricSquare square;
                    class_1799 stack = this.inventory.getGhostItem(i);
                    if (!stack.method_7960() && (square = FabricSquareRegistry.forItem(stack)) != null) {
                        this.paintSquare(context, ix, iy, this.panelSize, this.panelSize, square);
                    }
                    ix += dx;
                    iy += dy;
                }
                break block4;
            }
            if (this.exemplarInventory == null) break block4;
            class_1799 exemplar = this.exemplarInventory.method_5438(this.exemplarSlot);
            class_2499 list = FabricSquareRegistry.getStaplerData(exemplar);
            int squares = Math.min(this.maxSquares, list.size());
            for (int i = 0; i < squares; ++i) {
                class_2487 squareNbt = list.method_10602(i);
                FabricSquare square = FabricSquare.fromCompound(squareNbt);
                this.paintSquare(context, ix, iy, this.panelSize, this.panelSize, square);
                ix += dx;
                iy += dy;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void paintSquare(class_332 context, int x, int y, int width, int height, FabricSquare square) {
        class_1044 tex = class_310.method_1551().method_1531().method_4619(class_1723.field_21668);
        if (tex instanceof class_1059) {
            class_1059 atlas = (class_1059)tex;
            class_1058 sprite = atlas.method_4608(square.id());
            float uPx = (sprite.method_4577() - sprite.method_4594()) / 16.0f;
            float vPx = (sprite.method_4575() - sprite.method_4593()) / 16.0f;
            float uofs = uPx * (float)square.xofs();
            float vofs = vPx * (float)square.yofs();
            float minU = sprite.method_4594() + uofs;
            float minV = sprite.method_4593() + vofs;
            float maxU = minU + uPx * 8.0f;
            float maxV = minV + vPx * 8.0f;
            ScreenDrawing.texturedRect((class_332)context, (int)x, (int)y, (int)width, (int)height, (class_2960)class_1723.field_21668, (float)minU, (float)minV, (float)maxU, (float)maxV, (int)square.color());
        } else {
            ScarvesMod.LOGGER.error("Block Atlas Texture isn't a block atlas");
        }
    }
}

