/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.scarves.api;

import blue.endless.scarves.ScarvesMod;
import blue.endless.scarves.api.FabricSquare;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class FabricSquareRegistry {
    private static Map<class_1935, FabricSquare> entries = new HashMap<class_1935, FabricSquare>();

    public static void register(class_1935 item, FabricSquare square) {
        entries.remove(item);
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2248 block = blockItem.method_7711();
            entries.put((class_1935)block, square);
        } else if (item instanceof class_2248) {
            class_2248 block = (class_2248)item;
            entries.remove(block.method_8389());
            entries.put(item, square);
        } else {
            entries.put(item, square);
        }
    }

    public static void register(class_2248 block, class_2960 texture) {
        if (block.method_9564().method_26213() >= 8) {
            entries.put((class_1935)block, new FabricSquare(texture, 4, 4, -1, -1, true));
        } else {
            entries.put((class_1935)block, new FabricSquare(texture));
        }
    }

    public static void register(class_2248 block, String texture) {
        FabricSquareRegistry.register(block, new class_2960(texture));
    }

    @Nullable
    public static FabricSquare forItemConvertible(class_1935 item) {
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2248 block = blockItem.method_7711();
            return entries.get(block);
        }
        return entries.get(item);
    }

    @Nullable
    public static FabricSquare forItem(class_1799 stack) {
        class_2487 tag = stack.method_7941("FabricSquare");
        if (tag != null) {
            return FabricSquare.fromCompound(tag);
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2248 block = blockItem.method_7711();
            return entries.get(block);
        }
        return entries.get(item);
    }

    public static boolean isFabricSquare(class_1799 stack) {
        class_2487 tag = stack.method_7941("FabricSquare");
        if (tag != null) {
            return true;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2248 block = blockItem.method_7711();
            return entries.containsKey(block);
        }
        return entries.containsKey(item);
    }

    public static boolean canBeStapled(class_1799 stack) {
        boolean hasLeftData;
        if (FabricSquareRegistry.isFabricSquare(stack)) {
            return true;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return false;
        }
        class_2499 leftScarfTag = tag.method_10554("LeftScarf", 10);
        class_2499 rightScarfTag = tag.method_10554("RightScarf", 10);
        boolean bl = leftScarfTag == null ? false : (hasLeftData = leftScarfTag.size() > 0);
        boolean hasRightData = rightScarfTag == null ? false : rightScarfTag.size() > 0;
        return hasLeftData ^ hasRightData;
    }

    public static class_2499 getStaplerData(class_1799 stack) {
        boolean hasRightData;
        boolean hasLeftData;
        if (FabricSquareRegistry.isFabricSquare(stack)) {
            class_2499 result = new class_2499();
            result.add((Object)FabricSquareRegistry.forItem(stack).toCompound());
            return result;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return new class_2499();
        }
        class_2499 leftScarfTag = tag.method_10554("LeftScarf", 10);
        class_2499 rightScarfTag = tag.method_10554("RightScarf", 10);
        boolean bl = leftScarfTag == null ? false : (hasLeftData = leftScarfTag.size() > 0);
        boolean bl2 = rightScarfTag == null ? false : (hasRightData = rightScarfTag.size() > 0);
        if (hasLeftData) {
            return leftScarfTag;
        }
        if (hasRightData) {
            return rightScarfTag;
        }
        return new class_2499();
    }

    public static void logDump() {
        ScarvesMod.LOGGER.info("There are " + entries.size() + " entries in the FabricSquareRegistry:");
        entries.forEach((item, entry) -> ScarvesMod.LOGGER.info(item + " -> " + entry));
    }
}

