/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.scarves.client;

import blue.endless.scarves.ScarvesBlocks;
import blue.endless.scarves.ScarvesItems;
import blue.endless.scarves.client.IScarfHaver;
import blue.endless.scarves.client.ITickDeprivationAware;
import blue.endless.scarves.client.ScarfNode;
import blue.endless.scarves.client.ScarfRenderer;
import blue.endless.scarves.client.ScarfStaplerScreen;
import blue.endless.scarves.client.ScarfTableScreen;
import blue.endless.scarves.ghost.GhostInventoryNetworking;
import blue.endless.scarves.gui.ScarfStaplerGuiDescription;
import blue.endless.scarves.gui.ScarfTableGuiDescription;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3929;
import net.minecraft.class_765;

public class ScarvesClient
implements ClientModInitializer {
    public static final double SCARF_GRAVITY = -0.01;
    public static final int UNCOLORED_SCARF_TINT = -2242389;

    public void onInitializeClient() {
        WorldRenderEvents.BEFORE_ENTITIES.register(ScarvesClient::beforeEntities);
        GhostInventoryNetworking.initClient();
        class_3929.method_17542(ScarvesBlocks.SCARF_STAPLER_SCREEN_HANDLER, (gui, inventory, title) -> new ScarfStaplerScreen((ScarfStaplerGuiDescription)gui, inventory, title));
        class_3929.method_17542(ScarvesBlocks.SCARF_TABLE_SCREEN_HANDLER, (gui, inventory, title) -> new ScarfTableScreen((ScarfTableGuiDescription)gui, inventory, title));
        ColorProviderRegistry.ITEM.register(ScarvesClient::getScarfTint, (Object[])new class_1935[]{ScarvesItems.SCARF});
    }

    public static int getScarfTint(class_1799 stack, int index) {
        int colorHint;
        class_2499 scarf;
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return -2242389;
        }
        class_2499 leftScarf = tag.method_10554("LeftScarf", 10);
        class_2499 rightScarf = tag.method_10554("RightScarf", 10);
        class_2499 class_24992 = scarf = leftScarf == null || leftScarf.size() == 0 ? rightScarf : leftScarf;
        if (scarf.size() == 0) {
            return -2242389;
        }
        class_2487 square = scarf.method_10602(index % scarf.size());
        int n = colorHint = square.method_10573("ColorHint", 3) ? square.method_10550("ColorHint") : -1;
        if (colorHint != -1) {
            return colorHint;
        }
        int color = square.method_10573("Color", 3) ? square.method_10550("Color") : -1;
        return color;
    }

    public static void beforeEntities(WorldRenderContext ctx) {
        ctx.matrixStack().method_22903();
        class_243 pos = ctx.camera().method_19326();
        ctx.matrixStack().method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        for (class_1297 entity : ctx.world().method_18112()) {
            if (!(entity instanceof IScarfHaver)) continue;
            IScarfHaver scarfHaver = (IScarfHaver)entity;
            try {
                boolean bl;
                if (entity instanceof ITickDeprivationAware) {
                    ITickDeprivationAware depAware = (ITickDeprivationAware)entity;
                    bl = depAware.engination_isTickDeprived(ctx.world().method_8510());
                } else {
                    bl = false;
                }
                boolean tickDeprived = bl;
                scarfHaver.iScarfHaver_getAttachments(ctx.tickDelta()).forEach(it -> {
                    List<ScarfNode> nodes = it.nodes();
                    if (nodes.isEmpty()) {
                        return;
                    }
                    nodes.get(0).pullTowards(it.getLocation());
                    if (nodes.size() > 1) {
                        for (int i = 1; i < nodes.size(); ++i) {
                            ScarfNode prev = nodes.get(i - 1);
                            ScarfNode cur = nodes.get(i);
                            cur.pullTowards(prev.position);
                        }
                    }
                    class_243 prev = it.getLocation();
                    class_243 prevUp = new class_243(0.0, 1.0, 0.0).method_1021((double)0.3f);
                    for (int i = 0; i < nodes.size(); ++i) {
                        ScarfNode cur = nodes.get(i);
                        class_243 lerpedPos = tickDeprived ? cur.getPosition() : cur.getLerpedPosition(ctx.tickDelta());
                        class_2338 curPos = new class_2338((int)lerpedPos.field_1352, (int)(lerpedPos.field_1351 + 0.25), (int)lerpedPos.field_1350);
                        class_243 forwardVec = lerpedPos.method_1020(prev).method_1029();
                        class_243 tempUpVec = forwardVec.field_1352 == 0.0 && forwardVec.field_1350 == 0.0 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 1.0, 0.0);
                        class_243 rightVec = forwardVec.method_1036(tempUpVec);
                        class_243 curUp = forwardVec.method_1036(rightVec).method_1021((double)0.3f);
                        int nodeLight = cur.square.emissive() ? class_765.method_23687((int)15, (int)15) : class_765.method_23687((int)ctx.world().method_8314(class_1944.field_9282, curPos), (int)ctx.world().method_8314(class_1944.field_9284, curPos));
                        ScarfRenderer.quad(prev, prev.method_1019(prevUp), lerpedPos.method_1019(curUp), lerpedPos, cur.square, ctx.consumers(), ctx.matrixStack(), nodeLight);
                        prev = lerpedPos;
                        prevUp = curUp;
                    }
                });
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ctx.matrixStack().method_22909();
    }
}

