/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.scarves.integration;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.scarves.ScarvesMod;
import blue.endless.scarves.api.FabricSquare;
import blue.endless.scarves.api.FabricSquareRegistry;
import gay.debuggy.staticdata.api.StaticData;
import gay.debuggy.staticdata.api.StaticDataItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_7923;

public class StaticDataIntegration {
    private static Map<class_2960, JsonElement> deferrals = new HashMap<class_2960, JsonElement>();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void init() {
        Jankson jankson = Jankson.builder().build();
        for (StaticDataItem dataItem : StaticData.getDataInDirectory((class_2960)new class_2960("scarves:fabric_squares"), (boolean)true)) {
            try {
                JsonElement elem = jankson.loadElement(dataItem.getAsStream());
                if (!(elem instanceof JsonObject)) continue;
                JsonObject obj = (JsonObject)elem;
                obj.forEach((itemIdString, squareSpec) -> {
                    class_2960 itemId = new class_2960(itemIdString);
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                    if (item == null || item == class_1802.field_8162) {
                        deferrals.put(itemId, (JsonElement)squareSpec);
                    } else {
                        StaticDataIntegration.getFabricSquare(squareSpec, StaticDataIntegration.getColorHint(item), StaticDataIntegration.getDefaultEmissive(item)).ifPresent(square -> FabricSquareRegistry.register((class_1935)item, square));
                    }
                });
            }
            catch (Throwable t) {
                ScarvesMod.LOGGER.error("Could not load static data \"" + dataItem.getResourceId() + "\"", t);
            }
        }
        RegistryEntryAddedCallback.event((class_2378)class_7923.field_41178).register((rawId, id, item) -> {
            JsonElement elem = deferrals.remove(id);
            if (elem == null) {
                return;
            }
            try {
                StaticDataIntegration.getFabricSquare(elem, StaticDataIntegration.getColorHint(item), StaticDataIntegration.getDefaultEmissive(item)).ifPresent(square -> FabricSquareRegistry.register((class_1935)item, square));
            }
            catch (Throwable t) {
                ScarvesMod.LOGGER.error("Could not load static data for deferred item \"" + id + "\"", t);
            }
        });
    }

    public static Optional<FabricSquare> getFabricSquare(JsonElement elem, int defaultColor, boolean defaultEmissive) {
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive prim = (JsonPrimitive)elem;
            Object object = prim.getValue();
            if (object instanceof String) {
                String str = (String)object;
                return Optional.of(new FabricSquare(new class_2960(str), 4, 4, -1, defaultColor, defaultEmissive));
            }
            object = prim.getValue();
            if (object instanceof Long) {
                Long l = (Long)object;
                return Optional.of(new FabricSquare(new class_2960("minecraft:block/white_wool"), 4, 4, l.intValue(), l.intValue(), defaultEmissive));
            }
            return Optional.empty();
        }
        if (elem instanceof JsonObject) {
            JsonObject obj = (JsonObject)elem;
            String textureId = (String)obj.get(String.class, "texture");
            if (textureId == null) {
                return Optional.empty();
            }
            int xofs = obj.getInt("x", 4);
            int yofs = obj.getInt("y", 4);
            int color = StaticDataIntegration.parseColor(obj.get((Object)"color"), -1);
            int colorHint = StaticDataIntegration.parseColor(obj.get((Object)"color_hint"), defaultColor);
            boolean emissive = obj.getBoolean("emissive", defaultEmissive);
            return Optional.of(new FabricSquare(new class_2960(textureId), xofs, yofs, color, colorHint, emissive));
        }
        return Optional.empty();
    }

    public static int getColorHint(class_1792 item) {
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            int baseColor = blockItem.method_7711().method_26403().method_15820(class_3620.class_6594.field_34760);
            int b = baseColor >> 16 & 0xFF;
            int g = baseColor >> 8 & 0xFF;
            int r = baseColor & 0xFF;
            return r << 16 | g << 8 | b;
        }
        return -1;
    }

    public static boolean getDefaultEmissive(class_1792 item) {
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711().method_9564().method_26213() >= 8;
        }
        return false;
    }

    public static int parseColor(JsonElement elem, int defaultColor) {
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive prim = (JsonPrimitive)elem;
            Object object = prim.getValue();
            if (object instanceof String) {
                String str = (String)object;
                if (str.startsWith("#")) {
                    str = str.substring(1);
                }
                if (str.length() == 3) {
                    int r = StaticDataIntegration.hexDigit(str.charAt(0));
                    r |= r << 4;
                    int g = StaticDataIntegration.hexDigit(str.charAt(1));
                    g |= g << 4;
                    int b = StaticDataIntegration.hexDigit(str.charAt(2));
                    b |= b << 4;
                    return 0xFF000000 | r << 16 | g << 8 | b;
                }
                if (str.length() == 6) {
                    int r = StaticDataIntegration.hexDigit(str.charAt(0)) << 4 | StaticDataIntegration.hexDigit(str.charAt(1));
                    int g = StaticDataIntegration.hexDigit(str.charAt(2)) << 4 | StaticDataIntegration.hexDigit(str.charAt(3));
                    int b = StaticDataIntegration.hexDigit(str.charAt(4)) << 4 | StaticDataIntegration.hexDigit(str.charAt(5));
                    return 0xFF000000 | r << 16 | g << 8 | b;
                }
                return defaultColor;
            }
            object = prim.getValue();
            if (object instanceof Long) {
                Long l = (Long)object;
                return l.intValue() | 0xFF000000;
            }
        }
        return defaultColor;
    }

    private static final int hexDigit(char ch) {
        ch = Character.toLowerCase(ch);
        for (int i = 0; i < HEX_DIGITS.length; ++i) {
            if (HEX_DIGITS[i] != ch) continue;
            return i;
        }
        return 0;
    }
}

