/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.scarves.mixin;

import blue.endless.scarves.ScarvesItems;
import blue.endless.scarves.api.ScarfLogic;
import blue.endless.scarves.client.IScarfHaver;
import blue.endless.scarves.client.ITickDeprivationAware;
import blue.endless.scarves.client.ScarfAttachment;
import blue.endless.scarves.client.SimpleScarfAttachment;
import com.mojang.authlib.GameProfile;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4050;
import net.minecraft.class_745;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_746.class, class_745.class})
public abstract class ClientPlayerEntityMixin
extends class_1657
implements IScarfHaver,
ITickDeprivationAware {
    private static final float SCARF_TAIL_SEPARATION = 0.19f;
    private SimpleScarfAttachment scarves_leftScarf;
    private SimpleScarfAttachment scarves_rightScarf;
    private long scarves_lastValidTick;

    public ClientPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Override
    public Stream<ScarfAttachment> iScarfHaver_getAttachments(float delta) {
        TrinketComponent component = TrinketsApi.getTrinketComponent((class_1309)((class_1309)this)).orElse(null);
        if (component != null) {
            boolean tickDeprived;
            if (component.getEquipped((class_1792)ScarvesItems.SCARF).size() == 0) {
                return Stream.empty();
            }
            if (this.scarves_leftScarf == null) {
                this.scarves_leftScarf = new SimpleScarfAttachment();
            }
            if (this.scarves_rightScarf == null) {
                this.scarves_rightScarf = new SimpleScarfAttachment();
            }
            class_243 planarLookVec = class_243.method_1030((float)0.0f, (float)this.method_36454());
            class_243 upVec = new class_243(0.0, 1.0, 0.0);
            class_243 rightVec = planarLookVec.method_1036(upVec);
            class_4050 pose = this.method_18376();
            double posedEyeHeight = (double)this.method_18381(this.method_18376()) - 0.4;
            class_243 referencePos = new class_243(0.0, posedEyeHeight, 0.0);
            if (!this.getClass().equals(class_746.class) || !class_310.method_1551().field_1690.method_31044().method_31034()) {
                if (pose == class_4050.field_18077) {
                    lookVec = class_243.method_1030((float)this.method_36455(), (float)this.scarves$getBodyYaw(delta));
                    referencePos = referencePos.method_1019(lookVec.method_1021(1.5));
                } else if (pose == class_4050.field_18079) {
                    lookVec = class_243.method_1030((float)this.method_36455(), (float)this.scarves$getBodyYaw(delta));
                    referencePos = referencePos.method_1019(lookVec.method_1021(0.7)).method_1031(0.0, 0.25, 0.0);
                }
            }
            boolean bl = tickDeprived = this.method_5770() == null ? false : this.engination_isTickDeprived(this.method_5770().method_8510());
            if (tickDeprived) {
                this.scarves_leftScarf.setLocation(this.method_19538().method_1019(referencePos).method_1019(rightVec.method_1021((double)-0.19f)).method_1019(planarLookVec.method_1021(-0.25)));
                this.scarves_rightScarf.setLocation(this.method_19538().method_1019(referencePos).method_1019(rightVec.method_1021((double)0.19f)).method_1019(planarLookVec.method_1021(-0.25)));
            } else {
                this.scarves_leftScarf.setLocation(this.method_30950(delta).method_1019(referencePos).method_1019(rightVec.method_1021((double)-0.19f)).method_1019(planarLookVec.method_1021(-0.25)));
                this.scarves_rightScarf.setLocation(this.method_30950(delta).method_1019(referencePos).method_1019(rightVec.method_1021((double)0.19f)).method_1019(planarLookVec.method_1021(-0.25)));
            }
            return Stream.of(this.scarves_leftScarf, this.scarves_rightScarf);
        }
        return Stream.empty();
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void afterTick(CallbackInfo ci) {
        class_1937 world = this.method_5770();
        if (world != null) {
            this.scarves_lastValidTick = world.method_8510();
        }
        this.scarves$updateScarfAttachments();
    }

    private void scarves$updateScarfAttachments() {
        TrinketComponent component = TrinketsApi.getTrinketComponent((class_1309)((class_1309)this)).orElse(null);
        if (component != null) {
            for (class_3545 equipped : component.getEquipped((class_1792)ScarvesItems.SCARF)) {
                class_2499 rightScarfTag;
                class_1799 stack = (class_1799)equipped.method_15441();
                class_2487 tag = stack.method_7969();
                if (tag == null) {
                    if (this.scarves_leftScarf != null) {
                        this.scarves_leftScarf.nodes().clear();
                    }
                    if (this.scarves_rightScarf == null) continue;
                    this.scarves_rightScarf.nodes().clear();
                    continue;
                }
                class_2499 leftScarfTag = tag.method_10554("LeftScarf", 10);
                if (leftScarfTag != null) {
                    if (this.scarves_leftScarf == null) {
                        this.scarves_leftScarf = new SimpleScarfAttachment();
                    }
                    ScarfLogic.updateScarfAttachment(this.scarves_leftScarf, this.method_37908(), (class_1297)this, this.method_19538(), leftScarfTag);
                }
                if ((rightScarfTag = tag.method_10554("RightScarf", 10)) == null) continue;
                if (this.scarves_rightScarf == null) {
                    this.scarves_rightScarf = new SimpleScarfAttachment();
                }
                ScarfLogic.updateScarfAttachment(this.scarves_rightScarf, this.method_37908(), (class_1297)this, this.method_19538(), rightScarfTag);
            }
        }
    }

    private float scarves$getBodyYaw(float tickDelta) {
        class_1297 class_12972;
        float result = class_3532.method_17821((float)tickDelta, (float)this.field_6220, (float)this.field_6283);
        float lerpedHedYaw = class_3532.method_17821((float)tickDelta, (float)this.field_6259, (float)this.field_6241);
        if (this.method_5765() && (class_12972 = this.method_5854()) instanceof class_1309) {
            class_1309 livingEntity2 = (class_1309)class_12972;
            result = class_3532.method_17821((float)tickDelta, (float)livingEntity2.field_6220, (float)livingEntity2.field_6283);
            float k = lerpedHedYaw - result;
            float l = class_3532.method_15393((float)k);
            if (l < -85.0f) {
                l = -85.0f;
            }
            if (l >= 85.0f) {
                l = 85.0f;
            }
            result = lerpedHedYaw - l;
            if (l * l > 2500.0f) {
                result += l * 0.2f;
            }
        }
        return result;
    }

    @Override
    public boolean engination_isTickDeprived(long currentTick) {
        long elapsed = currentTick - this.scarves_lastValidTick;
        return elapsed > 1L;
    }
}

